
clear all

V=2;

L=10;
d=L/20;
h=1;
eps2=1.45^2;
n=0:100000;

Vn=FourierExpander(V,L,d,n);

dx=L/1000;
x=(-L/2:dx:L/2)';


Vm=sum( (ones(size(x))*Vn) .* (sin(2*pi/L*x*n)),2);

[Vx]=mvV(x,V,L,d);
plot(x,Vx,x,Vm);
grid on

F_eps0_H = FourierForce(V,L,d,n,h,eps2);
F_eps0_H_ = FourierForceCheck(V,L,d,n,h,eps2);

F_eps0_H
F_eps0_H_ref=(V/2)^2/2 /h^2; % force for plate capacitor with V/2 and h
F_eps0_H/F_eps0_H_ref
%F_eps0_H/F_eps0_H_

htilde=2*pi*h/L;
dtilde=2*pi*d/L;
bf=basefunction(htilde,dtilde,n,eps2);
