n=0:3000;
eps2=1.45^2;
eps0=8.8541878128e-12; %Faraday/m
V=1000;

onemm=0.001;
h=onemm; % 1mm sample separation
htilde=0.01:0.0001:5;
dtilde=pi/10; % d=L/20;

L=2*pi*h./htilde;
d=dtilde.*L/(2*pi);

Vn=FourierExpander(V,L,d,n);
p  = eps0*FourierForce(V,L,d,n,h,eps2);
p_ = eps0*FourierForceCheck(V,L,d*0,n,h,eps2);

[pmax,indmax]=max(p);
Lmax=L(indmax);

startup;
figure(1);
loglog(L*1e3,p,L*1e3,p_,[L(indmax),L(indmax)]*1e3,[min(p),max(p)]);
title(['h=',num2str(h*1e3),'mm separation']);
legend('d=L/20','d=0','peak','Location','NorthEast');
grid on
ylabel('N/(m^2 kV^2)');
xlabel('L [mm]');


%%%%%%%%%%%%%%%%%%%%%%%%%%%
if 1
h=0.002*(0.01:0.01:3);
L=Lmax*ones(size(h));
d=L/20;
    
Vn=FourierExpander(V,L,d,n);
p  = eps0*FourierForce(V,L,d,n,h,eps2);
p_ = eps0*FourierForceCheck(V,L,d*0,n,h,eps2);

startup;
figure(2);
loglog(h*1e3,p,h*1e3,p_,[onemm,onemm]*1e3,[min(p),max(p)]);
title(['L=',num2str(Lmax*1e3,3),'mm periodicity']);
legend('d=L/20','d=0','h=1mm','Location','NorthEast');
grid on
ylabel('N/(m^2 kV^2)');
xlabel('h [mm]');
end