function [Vx] = mvV(x,V,L,d)

% V(x) = -V*(x+L/2)/d for -L/2        < x < -L/2 +d/2 
% V(x) = -V/2         for -L/2 +d/2 < x <        -d/2
% V(x) = +V*(x    )/d for      -d/2 < x <        +d/2
% V(x) = +V/2         for      +d/2 < x < +L/2   -d/2
% V(x) = -V*(x-L/2)/d for +L/2 -d/2 < x < +L/2
% V(x) =  V(x-L)      for           all x

x=mod(x+L/2,L)-L/2;

i1=and(-L/2        <= x, x  <  -L/2 +d/2);
i2=and(-L/2 +d/2 <= x, x  <       -d/2);
i3=and(     -d/2 <= x, x  <       +d/2);
i4=and(     +d/2 <= x, x  <  +L/2 -d/2);
i5=and(+L/2 -d/2 <= x, x  <  +L/2       );

if(d==0)
    Vx=i2*(-V/2          ) + ... 
       i4*(+V/2          ) ;
else
    Vx=i1.*(-V*(x+L/2)/d) + ...
       i2.*(-V/2          ) + ... 
       i3.*(+V*(x    )/d) + ... 
       i4.*(+V/2          ) + ...
       i5.*(-V*(x-L/2)/d) ;
end