function F_eps0_A = FourierForce(V,L,d,n,h,eps2)

[Vn]=FourierExpander(V,L,d,n);

F_eps0_A=0;
n_=n;
NN=size(Vn,1);
for ii=1:length(n_)
    n=n_(ii);
    if(mod(n,2)==1)
        k=2*pi*n./L;
        dn=cosh(k.*h)+eps2*sinh(k.*h);
        if NN==1
            F_eps0_A = F_eps0_A + k.^2.*(eps2^2-1)./(4*dn.^2) .*Vn(ii).^2; % attractive pos
        else
            F_eps0_A = F_eps0_A + k.^2.*(eps2^2-1)./(4*dn.^2) .*Vn(ii,:).^2; % attractive pos
        end
    end
end
%F_eps0_A % Force per epsilon_0 per average area

