function [Vn]=FourierExpander(V,L,d,n)
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
% Calculates Fourier coefficients for gapped square wave
%
% V(x) = -V*(x+L/2)/d for -L/2        < x < -L/2 +d/2 
% V(x) = -V/2         for -L/2 +d/2 < x <        -d/2
% V(x) = +V*(x    )/d for      -d/2 < x <        +d/2
% V(x) = +V/2         for      +d/2 < x < +L/2   -d/2
% V(x) = -V*(x-L/2)/d for +L/2 -d/2 < x < +L/2
% V(x) =  V(x-L)      for           all x
%
%
%
% V(x) =sum_n=1..infty [ b_n sin(2*pi/L*x*n)  ]
%
% The function returns a vector of Vn with the same size as n.
% Example: The first 10 coefficients for V0=1, L=1, d=0.01
%            Vn = FourierExpander(1,1,0.01,1:10)
%
%            Vn = 0 for n even
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%

N1=length(d);
N2=length(L);
N=max(N1,N2);
if N==1
  Vn=zeros(size(n));
else
  Vn=zeros(length(n),N);
end
n_=n;
for ii=1:length(n_);
    n=n_(ii);
    if(mod(n,2)==1)
        if N==1
            Vn(ii)=2*V/(pi*n) * sinc(d*n./L);
        else
            Vn(ii,:)=2*V/(pi*n) * sinc(d*n./L);
        end
    end
end



        %if(d==0) 
            %Vn(ii)= V*2/(pi*n);
        %else
            %k=2*pi*n/L;
            %p=k*d/2;
            %p=pi*d*n/L;
            %Vn(ii)= V*2*L/d/(pi*n)^2*(sin(p)-p*cos(p)) + ...
            %        V*2      /(pi*n) * cos(p);
        %end
