%% CEDOC.CLS
%%
%% CE Document Class
%%
%% All options are passed to the underlying article class implementation
%% 
%% The following macros are defined:
%% 
%%   \title{title}
%%      document title
%%   \author{authors}
%%      list of authors
%%   \institution{institution}
%%      list of author's institutions
%%   \date{date}
%%      publication date
%%   \cedccnumber{T}{YY}{NNNN}{VV}
%%      ce document control number
%%        T     document type identifier
%%        YY    two digit year
%%        NNNN  four digit serial number
%%        VV    two digit version number
%%        G     working group identifier
%%   \cedistribution{group}
%%      includes ``Distribution of this document: <group>'' on the title page
%%   \cenote{note}
%%      includes the specified note on the title page
%%   \ceinternal
%%      sets note to ``This is an internal working note of the ce project.''
%%   \cepublished{journal}
%%      sets note to ``To be published in <journal>''
%%   \cesubmitted{journal}
%%      sets note to ``Submitted for publication in <journal>''
%%   \cedraft
%%      includes the label ``Draft'' on every page
%%   \cerestricted{group}
%%      includes the label ``Circulation resitricted to <group>'' on every page
%%   \cesites
%%      include ce site information on the title page
%% 
%% Starting File:
%% Shourov K. Chatterji
%% shourov@ligo.mit.edu
%% 2003-Jun-18
%%
%% Adapted for CE by Lisa Barsotti, Josh Smith, 
%% Kevin Kuns
%% 2022-Aug-16

%---------- LATEX VERSION ----------
\NeedsTeXFormat{LaTeX2e}

%---------- CLASS NAME AND REVISION ----------
\ProvidesClass{cedoc}[2022/08/16 CE document class]

%---------- PROCESS OPTIONS ----------
\DeclareOption{letterpaper}{\PassOptionsToClass{\CurrentOption}{article}}
\DeclareOption{12pt}{\PassOptionsToClass{\CurrentOption}{article}}
\DeclareOption{oneside}{\PassOptionsToClass{\CurrentOption}{article}}
\DeclareOption{onecolumn}{\PassOptionsToClass{\CurrentOption}{article}}
\DeclareOption{final}{\PassOptionsToClass{\CurrentOption}{article}}
\DeclareOption*{\PassOptionsToClass{\CurrentOption}{article}}
\ExecuteOptions{letterpaper,12pt,oneside,onecolumn,final}
\ProcessOptions\relax

%---------- LOAD PARENT CLASS ----------
\LoadClass{article}

%---------- LOAD REQUIRED PACKAGES ----------
\RequirePackage{latexsym}
\RequirePackage{amsmath}
\RequirePackage{amsfonts}
\RequirePackage{amssymb}
\RequirePackage{graphicx}
\RequirePackage{color}
\RequirePackage{hyperref}
\RequirePackage{ifthen}
\RequirePackage{array}
\RequirePackage{calc}
\RequirePackage{vmargin}
\RequirePackage{titlesec}
\RequirePackage{caption}
\RequirePackage{float}
\RequirePackage{parskip}

%---------- SET MARGINS, INDENTATION, AND SPACING ----------
\setpapersize[portrait]{USletter}
\setmarginsrb{1in}{0.5in}{1in}{0.5in}{0.3in}{0.2in}{0.3pt}{0.4in}
\setlength{\parindent}{0pt}
\setlength{\parskip}{\baselineskip}

%---------- SET PAGE COLOR ----------
\pagecolor{white}

%---------- DEFAULT ce DOCUMENT PROPERTIES ----------
\def\@cedcctype{\relax}
\def\@cedccyear{\relax}
\def\@cedccserial{\relax}
\def\@cedccversion{\relax}
\def\@cedccgroup{\relax}
\def\@cedccshort{\relax}
\def\@cedccnumber{\relax}
\def\@cedistribution{\relax}
\def\@cedraft{\relax}
\def\@cerestricted{\relax}
\def\@cenote{\relax}
\def\@cesites{\relax}
\def\@institution{\relax}
\def\@cvsid{\relax}

%---------- MACRO TO PARSE CVS ID TAG ----------
\def\setcvsid#1{\def\next##1#1{\def\@cvsid{\mbox{%
  CVS ##1 --- Processed with \LaTeX\ on \today}}}\next}

%---------- COMMANDS TO SET ce DOCUMENT PROPERTIES ----------
\newcommand{\cedccnumber}[4]{%
  \def\@cedcctype{#1}%
  \def\@cedccyear{#2}%
  \def\@cedccserial{#3}%
  \def\@cedccversion{#4}%
  \def\@cedccshort{#1#2#3}%
  \def\@cedccnumber{CE-#1#2#3-#4}%
  \ifthenelse{\equal\@cedcctype{C}}{%
    \def\@cedoctype{Contractual Note}%
  }{%
  \ifthenelse{\equal\@cedcctype{D}}{%
    \def\@cedoctype{Drawing}%
  }{%
  \ifthenelse{\equal\@cedcctype{E}}{%
    \def\@cedoctype{Engineering Note}%
  }{%
  \ifthenelse{\equal\@cedcctype{G}}{%
    \def\@cedoctype{Presentation}%
  }{%
  \ifthenelse{\equal\@cedcctype{L}}{%
    \def\@cedoctype{Correspondence}%
  }{%
  \ifthenelse{\equal\@cedcctype{M}}{%
    \def\@cedoctype{Administrative Note}%
  }{%
  \ifthenelse{\equal\@cedcctype{P}}{%
    \def\@cedoctype{Publication}%
  }{%
  \ifthenelse{\equal\@cedcctype{T}}{%
    \def\@cedoctype{Technical Note}%
  }{%
    \def\@cedoctype{}%
  }}}}}}}}%
}
\newcommand{\cedraft}{\def\@cedraft{Draft}}
\newcommand{\cerestricted}[1]{\def\@cerestricted{%
  Circulation restricted to #1}}
\newcommand{\cedistribution}[1]{\def\@cedistribution{%
  \textit{Distribution of this document:}\vspace{1ex}\\#1}}
\newcommand{\cenote}[1]{\def\@cenote{#1}}
\newcommand{\ceinternal}{\def\@cenote{%
  This is an internal working\\note of the COSMIC EXPLORER project.}}
\newcommand{\cepublished}[1]{\def\@cenote{%
  To be published in\\#1}}
\newcommand{\cesubmitted}[1]{\def\@cenote{%
  Submitted for publication in\\#1}}
\newcommand{\cesites}{\def\@cesites{true}}
\newcommand{\institution}[1]{\def\@institution{\\#1}}
\newcommand{\cvsid}[1]{\setcvsid#1}

%---------- REDEFINE DATE FORMAT ----------
\renewcommand{\today}{%
  \number\year/\ifnum\month<10 0\fi\number\month/\ifnum\day<10 0\fi\number\day}

%---------- ? ----------
\newcommand{\PreserveBackslash}[1]{\let\temp=\\#1\let\\=\temp}

%---------- LABEL LAST PAGE ----------
\AtEndDocument{\label{cedoc-lastpage}}

%---------- DEFINE FOOTERS AND HEADERS ----------
\def\ps@headings{
  \def\@evenfoot{\vbox to 0in{%
     \centering\sffamily\small\mbox{page \thepage{} of \hypersetup{pdfborder=0 0 0}\pageref{cedoc-lastpage}}%
     }}
  \def\@oddfoot{\vbox to 0in{%
     \centering\sffamily\small\mbox{page \thepage{} of \hypersetup{pdfborder=0 0 0}\pageref{cedoc-lastpage}}%
     }}
  \def\@oddhead{\vbox to 0in{%
     \vskip -0.3in%
     \centering\sffamily\hypersetup{pdfborder=0 0 0}\href{https://dcc.cosmicexplorer.org/cgi-bin/private/DocDB/ShowDocument?.submit=Number\&docid=\@cedccshort\&version=}%
     {\mbox{\@cedccnumber}}\rule{0pt}{0ex}\\
     \vspace{0.1in}
     \centering\mbox{\color{red} \@cedraft%
     \ifthenelse{\equal\@cedraft{\relax}}{}{%
       \ifthenelse{\equal\@cerestricted{\relax}}{}{:\ }}%
     \@cerestricted}%
     }}
  \def\@evenhead{\vbox to 0in{%
     \vskip -0.3in%
     \centering\sffamily\hypersetup{pdfborder=0 0 0}\href{https://dcc.cosmicexplorer.org/cgi-bin/private/DocDB/ShowDocument?.submit=Number\&docid=\@cedccshort\&version=}%
     {\mbox{\@cedccnumber}}\rule{0pt}{0ex}\\
     \vspace{0.1in}
     \centering\mbox{\color{red} \@cedraft%
     \ifthenelse{\equal\@cedraft{\relax}}{}{%
       \ifthenelse{\equal\@cerestricted{\relax}}{}{:\ }}%
     \@cerestricted}%
     }}
}

%---------- ENABLE HEADERS AND FOOTERS ----------
\pagestyle{headings}

%---------- Section headings are sans serif ----------
\titleformat*{\section}{\sffamily\Large\bfseries}
\titleformat*{\subsection}{\sffamily\large\bfseries}
\titleformat*{\subsubsection}{\sffamily\normalsize\bfseries}
\titleformat{\paragraph}[runin]%
{\normalfont\normalsize\bfseries}{\theparagraph}{1em}{}
\titleformat{\subparagraph}[runin]%
{\normalfont\normalsize\bfseries}{\thesubparagraph}{1em}{}

\titlespacing*{\section} {0pt}{3.5ex plus 1ex minus .2ex}{-0.2ex plus .2ex}
\titlespacing*{\subsection} {0pt}{3.25ex plus 1ex minus .2ex}{-0.2ex plus .2ex}
\titlespacing*{\subsubsection}{0pt}{3.25ex plus 1ex minus .2ex}{-0.2ex plus .2ex}
\titlespacing*{\paragraph} {0pt}{3.25ex plus 1ex minus .2ex}{1em}
\titlespacing*{\subparagraph} {\parindent}{3.25ex plus 1ex minus .2ex}{1em}

%----------Paragraph spacing----------
\setlength{\parskip}{0.5\baselineskip plus2pt minus2pt}

%---------- Captions are sans serif and hanging----------
\captionsetup{font=sf, labelfont={sf,bf}, format=hang}

%---------- Widows and orphants - I don't think so ----------
\widowpenalty10000
\clubpenalty10000

%---------- DEFINE TITLEPAGE ----------
\renewcommand\maketitle{%
  \thispagestyle{titleheadings}%
  \begin{center}
    \fontsize{12pt}{14pt}\selectfont%
    \mbox{%
    THE COSMIC EXPLORER GRAVITATIONAL WAVE OBSERVATORY}\\[0.75in]
  %  - COSMIC EXPLORER -\\
    %CALIFORNIA INSTITUTE OF TECHNOLOGY\\
    %MASSACHUSETTS INSTITUTE OF TECHNOLOGY\\[0.75in]
    \begin{tabular*}{5.5in}%
      {|*{1}{>{\PreserveBackslash\centering\hspace{0pt}}%
             p{1.5in-\tabcolsep*2-\arrayrulewidth*2/3}}%
        *{1}{>{\PreserveBackslash\centering\hspace{0pt}}%
             p{2.5in-\tabcolsep*2-\arrayrulewidth*2/3}}%
        *{1}{>{\PreserveBackslash\centering\hspace{0pt}}%
             p{1.5in-\tabcolsep*2-\arrayrulewidth*2/3}}|}
      \hline
      \textbf{\@cedoctype} &
      \href{https://dcc.cosmicexplorer.org/cgi-bin/private/DocDB/ShowDocument?.submit=Number\&docid=\@cedccshort\&version=}{\textbf{\@cedccnumber}} &
      \@date\rule[-2ex]{0pt}{5ex}\\
      \hline
      \multicolumn{3}{|p{5.5in-\tabcolsep*2-\arrayrulewidth*2}|}%
        {\rule{0pt}{5ex}\centering\parbox[t]{5in}%
          {\centering\fontsize{14pt}{18pt}\selectfont%
           \sffamily\LARGE\bfseries\@title\rule[-2ex]{0pt}{0pt}}}\\
      \hline
      \multicolumn{3}{|p{5.5in-\tabcolsep*2-\arrayrulewidth*2}|}%
        {\rule{0pt}{3ex}\centering\@author\textit{\@institution}%
         \rule[-2ex]{0pt}{0ex}}\\
      \hline
    \end{tabular*}\\
    \vspace{0.5in}
    \@cedistribution\rule{0pt}{0ex}\\
    \vspace{0.25in}
    {\color{red}\fontsize{14pt}{14pt}\selectfont\@cedraft\rule{0pt}{0ex}}\\
    {\color{red}\fontsize{14pt}{14pt}\selectfont\@cerestricted\rule{0pt}{0ex}}\\
    \vspace{0.25in}
    \@cenote\rule{0pt}{0ex}\\
    \vfill
    \includegraphics{CElogo.pdf} \\
    \vspace{0.2in}
  \href{http://www.cosmicexplorer.org/}{http://www.cosmicexplorer.org/}\\
  \end{center}
  \normalsize
  \newpage
}
\def\ps@titleheadings{%
  \let\@evenhead\@empty\let\@oddhead\@empty
  \def\@oddfoot{\hfil\mbox{\fontsize{9pt}{11pt}\selectfont\@cvsid}\hfil}%
  \def\@evenfoot{\hfil\mbox{\fontsize{9pt}{11pt}\selectfont\@cvsid}\hfil}%
}

%---------- AUTOMATICALLY GENERATE TITLE PAGE ----------
\AtBeginDocument{%
  %---------- PDF properties----------
  \hypersetup
  {
    pdfauthor={\@author},
    pdfsubject={\@cedoctype\ \@cedccnumber},
    pdftitle={\@title},
    pdfkeywords={Cosmic Explorer}
  }
  \maketitle
  \setcounter{page}{2}
}
